/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	CreateLineCenterToCenter.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CApplication.h"
#include "CLine.h"

//	Creates a line using the center points of the
//	two given circles and returns the line created
//	After creation the line is AutoConstrained.

HRESULT CreateLineCenterToCenter(ILine *circle1, ILine *circle2, ILine **newLine1)
{

	START_METHOD("CreateLineCenterToCenter")

	HRESULT status = CONV_SUCCESS;
	
	// Get the center point of the first circle
	IPoint *centerPoint1 = NULL;
	status = circle1->GetCenterPoint(&centerPoint1);
	CHECK_RETURN_STATUS(status)

	// Get the center point of the second circle
	IPoint *centerPoint2 = NULL;
	status = circle2->GetCenterPoint(&centerPoint2);
	CHECK_RETURN_STATUS(status)

	ILine *pLine1 = NULL;
	status = CreateLinePointToPoint(centerPoint1, centerPoint2, &pLine1);
	CHECK_RETURN_STATUS(status)

	*newLine1 = pLine1;

	END_METHOD("CreateLineCenterToCenter")
}
